﻿using System.Net;

internal class WebRequestorCore
{
    internal static HttpWebRequest CreateRequest(string requestUrl)
    {
        var request = WebRequest.Create(requestUrl) as HttpWebRequest;
        if (request == null)
            throw new WebException(string.Format("{0}: failed to create web request", requestUrl));

        return request;
    }

    internal static string GetResponse(WebRequest request, string requestUrl)
    {
        return request.GetResponseWithExponentialBackoff(requestUrl);
    }
}
